//
// Assets and source code of SCP Security Systems are licensed under Creative Commons Attribution-ShareAlike 3.0
//
import { Player, system, world } from "@minecraft/server";
import { setupKeypadSystem } from "./keypad";
import { setupEntityToolSpawner } from "./entityToolSpawner";
import { setupCctvSystem, tickCctvSystem } from "./cctv";
import { setupTeslaGateSystem } from "./teslaGate";

export const OVERWORLD = world.getDimension("overworld");
const INIT_TICK = 100;

let currentTick = 0;
let hostPlayer: Player;


export function getCurrentTick(): number {
  return currentTick;
}

export function getHostPlayer(): Player{
  if (hostPlayer !== undefined) return hostPlayer;

  hostPlayer = world.getPlayers()[0];
  if (hostPlayer !== undefined) return hostPlayer;

  world.sendMessage("§chostPlayer is undefined when it should be defined. This Minecraft bug will cause errors.");

  return hostPlayer;
}

function init() {
  getHostPlayer();
  hostPlayer.runCommand('function scpd/system/cleanup');

  setupKeypadSystem();
  setupEntityToolSpawner();
  setupCctvSystem();
  setupTeslaGateSystem();

  world.sendMessage('§7Initialized Scripts: SCP Security Systems');
}

function mainTick() {
  try {
    if (currentTick === INIT_TICK) {
      init();
    }

    if (currentTick >= INIT_TICK) {
      tickCctvSystem(currentTick);
    }

    currentTick++;
  }
  catch (ex) {
    world.sendMessage('§cError in main tick: ' + ex);
  }
}


system.runInterval(mainTick, 1);
